/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.launcher.i18n;

import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import technology.rocketjump.undermount.ui.i18n.LanguageType;

public class I18nCollator {
    public static final String CSV_SEPARATOR = "|";
    private List<LanguageType> languages;
    private Map<String, Map<String, String>> keysToLanguagesToValues = new LinkedHashMap<String, Map<String, String>>();

    public void init(FileHandle languagesDir) throws IOException {
        System.out.print("Parsing languages... ");
        ObjectMapper objectMapper = new ObjectMapper();
        this.languages = (List)objectMapper.readValue(FileUtils.readFileToString(languagesDir.child("languages.json").file(), "UTF-8"), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, LanguageType.class));
        LanguageType notesColumn = new LanguageType();
        notesColumn.setLabelEn("Notes");
        notesColumn.setLabel("Notes");
        notesColumn.setFilename(this.languages.get(0).getFilename());
        this.languages.add(1, notesColumn);
        for (LanguageType language : this.languages) {
            FileHandle languageCsvFile = languagesDir.child(language.getFilename());
            if (!languageCsvFile.exists()) {
                throw new RuntimeException("Could not find expected language file: " + languageCsvFile.name());
            }
            System.out.print(language.getLabelEn() + " ");
            CSVParser parsedCsv = CSVParser.parse(languageCsvFile.file(), Charset.forName("UTF-8"), CSVFormat.newFormat('|'));
            HashMap<String, Integer> columnIndices = new HashMap<String, Integer>();
            for (CSVRecord csvRecord : parsedCsv.getRecords()) {
                if (columnIndices.isEmpty()) {
                    for (int cursor = 0; cursor < csvRecord.size(); ++cursor) {
                        columnIndices.put(csvRecord.get(cursor).toUpperCase(), cursor);
                    }
                    continue;
                }
                String key = csvRecord.get((Integer)columnIndices.get("KEY"));
                if (key == null || key.isEmpty()) continue;
                key = key.toUpperCase();
                String value = csvRecord.get((Integer)columnIndices.get(language.getLabelEn().toUpperCase()));
                this.addValue(language, key, value);
            }
        }
        System.out.println();
    }

    private void addValue(LanguageType language, String key, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        Map<String, String> languageToValueMap = this.keysToLanguagesToValues.get(key);
        if (languageToValueMap == null) {
            languageToValueMap = new LinkedHashMap<String, String>();
            this.keysToLanguagesToValues.put(key, languageToValueMap);
        }
        languageToValueMap.put(language.getLabelEn().toUpperCase(), value);
    }

    public void outputTo(FileHandle targetFile) throws IOException {
        FileWriter fileWriter = new FileWriter(targetFile.file());
        fileWriter.append("KEY").append(CSV_SEPARATOR);
        for (LanguageType language : this.languages) {
            fileWriter.append(language.getLabelEn().toUpperCase()).append(CSV_SEPARATOR);
        }
        fileWriter.append("\n");
        ArrayList<String> allKeys = new ArrayList<String>(this.keysToLanguagesToValues.keySet());
        Collections.sort(allKeys);
        for (String key : allKeys) {
            fileWriter.append(key).append(CSV_SEPARATOR);
            for (LanguageType language : this.languages) {
                String value = this.keysToLanguagesToValues.get(key).get(language.getLabelEn().toUpperCase());
                if (value == null) {
                    value = "";
                }
                fileWriter.append(value).append(CSV_SEPARATOR);
            }
            fileWriter.append("\n");
        }
        fileWriter.flush();
        IOUtils.closeQuietly(fileWriter);
    }
}

